********************************************************************************
****    Estimate "YoY change in has job/not at work" in Appendix Table 15   ****
********************************************************************************


clear
cd "C:\Users\worri\Dropbox\Poverty\COVID19"
use Monthly_Poverty_0520.dta 

gen yr_month=year*100+month   
keep if yr_month>=201901
** replace asecflag 2 => asecflag . 
replace asecflag=. if asecflag==2 
keep if asecflag==.
keep yr_month whyabsnt wtfinl

** ten categories for why absent from work question
bysort yr_month: tab whyabsnt

keep if whyabsnt!=.
bysort yr_month: egen totpop = sum(wtfinl)
bysort yr_month whyabsnt: egen mo = sum(wtfinl)
collapse (mean) mo, by(whyabsnt yr_month)
reshape wide mo, i(whyabsnt) j(yr_month)
replace mo201903=0 if mo201903==.
replace mo201908=0 if mo201908==.
replace mo201912=0 if mo201912==.
replace mo202005=0 if mo202005==.
replace mo202006=0 if mo202006==.

** YOY change in the total number of people who are absent from work
drop if _n==1
forvalues m = 1/6 {
    gen YOY_change_20200`m' = mo20200`m' - mo20190`m'
}
collapse (sum) YOY*
xpose, varname clear
order _varname
export excel using App.T15.xlsx, firstrow(var) replace
